define([
    'App',
    'MainView',
    'Layout',
    'User',
    'backbone',
    'underscore',
    'jquery',
    'text!modules/page/content/_primary-header.html',
], function(App, View, Layout, User, Backbone, _, $, headerTemplate) {
    'use strict';


    /**
     * main-view.js needs to be broken up into better 'units' to be made testable.
     * As it stands several things are too heavily nested to be able to easily access them in unit tests.
     *
     * I would recommend limited refactoring.
     */
    describe('Main View', function() {
        var $div;
        var view;
        var layout;

        // This trick seems to only work on the window
        function getEvent(event, namespace) {
            var windowEvents = $._data($(window)[0], 'events');
            var _event = windowEvents[event];
            return _.filter(_event, function(e) {
                return e.namespace === namespace;
            });
        }


        beforeEach(function() {
            layout = new Layout();
            $div = $('<div id="main">');
            $('body').append($div);
        });

        afterEach(function() {
            $div.remove();
        });


        describe('constructor', function() {

            it('sets the model', function() {
                var defaultValue = new View();
                var hasAppMenu = defaultValue.model.get('hasAppMenu');

                expect(hasAppMenu).toBe(true);
            });
        });


        // TODO: The view should probably also fire $(.ui-popup).off in case the one never fired
        describe('destroy', function() {
            var THROTTLE_EVENT = 'throttledresize';
            var THROTTLE_NAMESPACE = 'mainview';

            var CHANGE_EVENT = 'orientationchange';
            var CHANGE_NAMESPACE = 'mainview';


            beforeEach(function() {
                spyOn(View.prototype, 'showAriaLiveLoadingView').and.callFake(_.noop);
                User.set('displayName', 'test');
            });

            it('removes all document and window event listeners', function() {
                var before;
                var after;
                view = new View();

                view.render();
                $div.append(view.$el);

                before = {
                    throttle: getEvent(THROTTLE_EVENT, THROTTLE_NAMESPACE),
                    change: getEvent(CHANGE_EVENT, CHANGE_NAMESPACE),
                };

                expect(before.throttle.length >= 1).toBe(true);
                expect(before.change.length >= 1).toBe(true);

                view.destroy();

                after = {
                    throttle: getEvent(THROTTLE_EVENT, THROTTLE_NAMESPACE),
                    change: getEvent(CHANGE_EVENT, CHANGE_NAMESPACE),
                };

                expect(after.throttle.length).toBe(0);
                expect(after.change.length).toBe(0);
                expect(view.showAriaLiveLoadingView).toHaveBeenCalled();

            });
        });

        describe('focusOnHeader', function() {
            var TESTING_TEXT = 'VA Appointments';

            beforeEach(function() {
                spyOn(View.prototype, 'showAriaLiveLoadingView').and.callFake(_.noop);
                view = new View();
                view.render();
            });

            afterEach(function() {
                view.destroy();
            });

            it('finds the header when a view is passed to it', function() {
                var TempContentView;
                var focusText;

                User.set('displayName', 'test');

                TempContentView = Backbone.Marionette.View.extend({template: _.template(headerTemplate)});


                // This method needs app.js setup so i am just killing it
                view.stopListening(view.content, 'show');

                view.showChildView('content', new TempContentView({
                    model: new Backbone.Model({
                        heading: TESTING_TEXT,
                        options: {},
                    }),
                }));

                view.focusOnHeader(view);

                // var focusText = $(':focus').text(); // Does not work in phantomjs
                focusText = document.activeElement.textContent;

                expect(focusText).toBe(TESTING_TEXT);
                expect(view.showAriaLiveLoadingView).toHaveBeenCalled();
            });

            it('finds the header when no view is passed', function() {
                var $header = $('#header .ui-title');
                var focusText;

                expect($header.length > 0).toBe(true);

                $header.text(TESTING_TEXT);
                view.focusOnHeader();

                // var focusText = $(':focus').text();  // Does not work in phantomjs
                focusText = document.activeElement.textContent;

                expect(focusText).toBe(TESTING_TEXT);
            });
        });

        describe('resizeContentAndMenus', function() {
            xit('resize #main-content correctly');
            xit('resize .menu-panel correctly');
        });


        // Easy test, but useful to ensure that the function does not all a sudden go away
        describe('clearContentRegion', function() {
            it('resets the content region', function() {
                var TinyView = Backbone.Marionette.View.extend({template: '<div id="my-test-id">TEST</div>'});
                var $el;
                view = new View();

                view.render();
                view.stopListening(view.content, 'show');

                view.showChildView('content', new TinyView());

                $el = $('#my-test-id');
                expect($el.length === 1).toBeTruthy();

                view.clearContentRegion();

                $el = $('#my-test-id');
                expect($el.length === 0).toBeTruthy();

            });
        });

        describe('firstTimeShowCrisisModal', function() {
            beforeEach(function() {
                localStorage.clear();
                spyOn(View.prototype, 'showCrisisModal').and.callFake(_.noop);
                spyOn(localStorage, 'setItem').and.callThrough();

                layout.render();
                view = new View();

            });
            afterEach(function() {
                localStorage.clear();
            });
            it('shows crisis popup on first load', function() {
                expect(localStorage.getItem('notFirstLogin')).toBeNull();
                view.firstTimeShowCrisisModal();
                expect(localStorage.getItem('notFirstLogin')).toBe('true');
                expect(view.showCrisisModal).toHaveBeenCalled();
                expect(localStorage.setItem).toHaveBeenCalled();
            });
            it('doesn\'t show crisis popup on second load', function() {
                localStorage.setItem('notFirstLogin', true);
                view.firstTimeShowCrisisModal();
                expect(view.showCrisisModal).not.toHaveBeenCalled();
            });
        });
    });
});
